/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.FlexDescEditorShell;

import javax.swing.JCheckBoxMenuItem;
import javax.swing.JOptionPane;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import net.nooj4nlp.controller.FlexDescEditorShell.FlexDescEditorShellController;
import net.nooj4nlp.gui.components.CursorChangeEffect;
import net.nooj4nlp.gui.main.Launcher;
import org.apache.commons.io.FilenameUtils;

public class CloseInternalFrameListener
implements InternalFrameListener {
    private FlexDescEditorShellController controller;

    public CloseInternalFrameListener(FlexDescEditorShellController controller) {
        this.controller = controller;
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent arg0) {
        boolean b = false;
        int n = Launcher.mnWindows.getItemCount();
        String basename = FilenameUtils.getBaseName(this.controller.getFullName()) + "." + FilenameUtils.getExtension(this.controller.getFullName());
        for (int i = 0; i < n; ++i) {
            if (Launcher.mnWindows.getItem(i) == null) continue;
            String aux = Launcher.mnWindows.getItem(i).getText();
            if (aux.equals(basename)) {
                Launcher.mnWindows.getItem(i).setSelected(true);
                b = true;
                continue;
            }
            Launcher.mnWindows.getItem(i).setSelected(false);
        }
        if (!b) {
            JCheckBoxMenuItem checkmenu = new JCheckBoxMenuItem(basename);
            checkmenu.setSelected(true);
            Launcher.mnWindows.add(checkmenu);
        }
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent arg0) {
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent arg0) {
        if (this.controller.isModified() && !Launcher.projectMode) {
            int answer = JOptionPane.showConfirmDialog(Launcher.getDesktopPane(), "NooJ: grammar file has not been saved", "Save grammar file?", 0);
            if (answer == 0) {
                try {
                    CursorChangeEffect.setCustomCursor(3);
                    this.controller.save();
                    this.controller.close();
                }
                finally {
                    CursorChangeEffect.setCustomCursor(0);
                }
            } else {
                this.controller.close();
            }
        } else {
            this.controller.close();
        }
        int n = Launcher.mnWindows.getItemCount();
        String basename = FilenameUtils.getBaseName(this.controller.getFullName()) + "." + FilenameUtils.getExtension(this.controller.getFullName());
        for (int i = 0; i < n; ++i) {
            String aux;
            if (Launcher.mnWindows.getItem(i) == null || !(aux = Launcher.mnWindows.getItem(i).getText()).equals(basename)) continue;
            Launcher.mnWindows.remove(i);
        }
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent arg0) {
    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent arg0) {
    }

    @Override
    public void internalFrameIconified(InternalFrameEvent arg0) {
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent arg0) {
    }
}

